% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_incorporateGenomicMutations.R
\name{incorporateGenomicVariants}
\alias{incorporateGenomicVariants}
\title{Incorporate genomic events into their overlapping exonic sequences}
\usage{
incorporateGenomicVariants(
  ProteoDiscography,
  aggregateSamples = FALSE,
  aggregateWithinExon = TRUE,
  aggregateWithinTranscript = TRUE,
  ignoreOverlappingMutations = TRUE,
  threads = 1
)
}
\arguments{
\item{ProteoDiscography}{({ProteoDiscography}): ProteoDiscography object which stores the annotation and genomic sequences.}

\item{aggregateSamples}{(logical): Should genomic mutations from different samples be incorporated within the same transcript?}

\item{aggregateWithinExon}{(logical): Should multiple mutations within the same exon be aggregated (TRUE) or should each mutation per exon produce a separate mutant transcript?}

\item{aggregateWithinTranscript}{(logical): Should multiple mutant exons within the same transcript be aggregated?}

\item{ignoreOverlappingMutations}{(logical): Incorporate first mutation (by order) and ignore subsequent overlapping mutations (and provide a warning) or stop the incorporation (if set to TRUE).
If aggregateWithinExon is set to FALSE, each mutations are added into separate exon to produce seperate transcripts.}

\item{threads}{(integer): Number of threads.}
}
\value{
{ProteoDiscography} with mutant transcript sequences containing SNVs, MNVs and InDels.
}
\description{
\code{incorporateMutations} Incorporates SNV, MNV and InDels present in the {ProteoDiscography} on the transcripts.
}
\examples{

# Import example ProteoDiscography (hg19)
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)
ProteoDiscographyExample.hg19 <- setGenomicSequences(ProteoDiscographyExample.hg19, BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# Incorporate the genomic variants.
ProteoDiscographyExample.hg19 <- ProteoDisco::incorporateGenomicVariants(
  ProteoDiscography = ProteoDiscographyExample.hg19,
  # Do not aggregate samples and generate mutant transcripts from the mutations per sample.
  aggregateSamples = FALSE,
  # If there are multiple mutations within the same exon (CDS), place them on the same mutant CDS sequence.
  aggregateWithinExon = TRUE,
  # Aggregate multiple mutant exons (CDS) within the same transcripts instead of incorporating one at a time.
  aggregateWithinTranscript = TRUE,
  # If there are overlapping mutations on the same coding position, retain only the first of the overlapping mutations.
  # If set to FALSE, throw an error and specify which CDS had overlapping mutations.
  ignoreOverlappingMutations = TRUE,
  # Number of threads.
  threads = 1
)

}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
