% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtest.R
\name{g.test}
\alias{g.test}
\title{G Test for presence - absence analysis}
\usage{
g.test(x, y = NULL, correct = "none", p = rep(1/length(x),
  length(x)))
}
\arguments{
\item{x}{vector of boolean values corresponding to presence & absence
eg: c(TRUE, TRUE, FALSE, FALSE) for present present absent absent
values. Order of TRUE/FALSE does not matter, can be used
interchangeably. Same length as parameter y}

\item{y}{vector treatments (factor) corresponding to values in x,
same length as x
eg: as.factor(c('grp1;, 'grp1', 'grp2', 'grp2'))}

\item{correct}{correction to apply, options: "yates", "williams", "none"
default: "none"
NOTE: in ProteoMM we only tested & used correction = "none"}

\item{p}{default: rep(1/length(x), length(x)), used in Yates correction
NOTE: in ProteoMM we only tested & used the default parameter value}
}
\value{
htest object the following variables
\describe{
  \item{statistic}{value of the G statistic produced by g test}
  \item{parameter}{degrees of freedom of the test}
  \item{p.value}{p-value}
  \item{method}{method used to produce statistic and p-value}
  \item{data.name}{data passed in to the function}
  \item{observed}{matrix of observed counts}
  \item{expected}{matrix of expected counts}
}
}
\description{
Log-likelihood test for independence & goodness of fit.
g.test() performs Williams' and Yates' correction;
Monte Carlo simulation of p-values, via gtestsim.c.
MC requires recompilation of R.
Written by Peter Hurd (V3.3 Pete Hurd Sept 29 2001, phurd AT ualberta.ca).
Yuliya Karpievitch added comments for ease of understanding and
incorporated into ProteoMM.
G & q calculation from Sokal & Rohlf (1995) Biometry 3rd ed.,
TOI Yates correction taken from Mike Camanns 2x2 G-test function,
GOF Yates correction as described in Zar (2000),
more stuff taken from ctest's chisq.test().
}
\examples{
g.test(c(TRUE, TRUE, FALSE, FALSE),
       as.factor(c('grp1', 'grp1', 'grp2', 'grp2')))
}
