% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{appendGDSgenotypeMat}
\alias{appendGDSgenotypeMat}
\title{Appends the genotype information for specific samples
(1 column == 1 profile) into a GDS file}
\usage{
appendGDSgenotypeMat(gds, matG)
}
\arguments{
\item{gds}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Profile GDS file.}

\item{matG}{a \code{matrix} of \code{integer} representing the genotypes
of the SNVs for one or multiple samples. The rows correspond to SNVs and
the columns correspond to samples. The number of rows must
correspond to the number of rows of the matrix present in the
"genotype" node.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function appends the genotype information into a
GDS file. More specifically, the genotype information is added to the
"genotype" node. The "genotype" node must already be present in the
GDS file. The genotype information is a matrix with the rows corresponding
to SNVs and columns corresponding to samples.
The number of rows of the new genotype information must
correspond to the number of rows of the matrix present in the
"genotype" node.
}
\examples{

## Required library
library(gdsfmt)

## Create a temporary GDS file
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_06.gds")

## Create and open the GDS file
tmpGDS  <- createfn.gds(filename=gdsFilePath)

## Create a "genotype" node with initial matrix
genoInitial <- matrix(rep(0L, 10), nrow=2)

add.gdsn(node=tmpGDS, name="genotype", val=genoInitial)
sync.gds(tmpGDS)

## New genotype information to be added
newGenotype <- matrix(rep(1L, 6), nrow=2)

## Add segments to the GDS file
RAIDS:::appendGDSgenotypeMat(gds=tmpGDS, matG=newGenotype)

## Read genotype information from GDS file
## The return matrix should be a combination of both initial matrix
## and new matrix (column binded)
read.gdsn(index.gdsn(node=tmpGDS, path="genotype"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
