% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{computePCARefRMMulti}
\alias{computePCARefRMMulti}
\title{Calculate Principal Component Analysis (PCA) on SNV genotype data set}
\usage{
computePCARefRMMulti(
  gdsProfile,
  refProfileIDs,
  listRM,
  np = 1L,
  algorithm = "exact",
  eigenCount = 32L,
  missingRate = 0.025,
  verbose
)
}
\arguments{
\item{gdsProfile}{an object of class \link[SNPRelate]{SNPGDSFileClass},
the opened Profile GDS file.}

\item{refProfileIDs}{a \code{vector} of reference 1KG profile identifiers
that are present in the Profile GDS file.
Those profiles minus the one present in the \code{listRM} vector will be
used to run the PCA analysis.}

\item{listRM}{a \code{vector} of \code{character} strings containing the
identifiers for the reference samples that need to be removed for the
PCA analysis.}

\item{np}{a single positive \code{integer} representing the number of CPU
that will be used. Default: \code{1L}.}

\item{algorithm}{a \code{character} string representing the algorithm used
to calculate the PCA. The 2 choices are "exact" (traditional exact
calculation) and "randomized" (fast PCA with randomized algorithm
introduced in Galinsky et al. 2016). Default: \code{"exact"}.}

\item{eigenCount}{a single \code{integer} indicating the number of
eigenvectors that will be in the output of the \link[SNPRelate]{snpgdsPCA}
function; if 'eigenCount' <= 0, then all eigenvectors are returned.
Default: \code{32L}.}

\item{missingRate}{a \code{numeric} value representing the threshold
missing rate at with the SNVs are discarded; the SNVs are retained in the
\link[SNPRelate]{snpgdsPCA} function
with "<= missingRate" only; if \code{NaN}, no missing threshold.
Default: \code{0.025}.}

\item{verbose}{a \code{logical} indicating if message information should be
printed.}
}
\value{
a \code{list} containing 2 entries:
\describe{
\item{pruned}{ a \code{vector} of SNV identifiers specifying selected SNVs
for the PCA analysis.}
\item{pca.unrel}{ a \code{snpgdsPCAClass} object containing the eigenvalues
as generated by \link[SNPRelate]{snpgdsPCA} function.}
}
}
\description{
The functions calculates the principal component analysis (PCA)
for a list of pruned SNVs present in a Profile GDS file. The
\link[SNPRelate]{snpgdsPCA} function is used to do the calculation.
}
\examples{

## Required library
library(SNPRelate)

## Load the known ancestry for the demo 1KG reference profiles
data(demoKnownSuperPop1KG)

# The name of the synthetic study
studyID <- "MYDATA.Synthetic"

## Profiles that should be removed from the PCA analysis
## Those profiles has been used to generate the synthetic data set
samplesRM <- c("HG00246", "HG00325", "HG00611", "HG01173", "HG02165",
    "HG01112", "HG01615", "HG01968", "HG02658", "HG01850", "HG02013",
    "HG02465", "HG02974", "HG03814", "HG03445", "HG03689", "HG03789",
    "NA12751", "NA19107", "NA18548", "NA19075", "NA19475", "NA19712",
    "NA19731", "NA20528", "NA20908")

## Path to the demo Profile GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")

## Open the Profile GDS file
gdsProfile <- snpgdsOpen(file.path(dataDir, "ex1.gds"))

## Compute PCA for the 1KG reference profiles excluding
## the profiles used to generate the synthetic profiles
results <- RAIDS:::computePCARefRMMulti(gdsProfile=gdsProfile,
    refProfileIDs=names(demoKnownSuperPop1KG), listRM=samplesRM, np=1L,
    algorithm="exact", eigenCount=32L, missingRate=0.025, verbose=FALSE)

## The PCA on the pruned SNVs data set for selected profiles
head(results$pca.unrel$eigenvect)

## Close Profile GDS file (important)
closefn.gds(gdsProfile)

}
\references{
Galinsky KJ, Bhatia G, Loh PR, Georgiev S, Mukherjee S, Patterson NJ,
Price AL. Fast Principal-Component Analysis Reveals Convergent Evolution
of ADH1B in Europe and East Asia. Am J Hum Genet. 2016 Mar 3;98(3):456-72.
doi: 10.1016/j.ajhg.2015.12.022. Epub 2016 Feb 25.
}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
