% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{processBlockChr}
\alias{processBlockChr}
\title{The function create a vector of integer representing the linkage
disequilibrium block for each SNV in the in the same order
than the variant in Population reference dataset.}
\usage{
processBlockChr(fileReferenceGDS, fileBlock)
}
\arguments{
\item{fileReferenceGDS}{a \code{character} string representing the file
name of the Reference GDS file. The file must exist.}

\item{fileBlock}{a \code{character} string representing the file
name of output file det from the plink block command for a chromosome.}
}
\value{
a \code{list} containing 2 entries:
\describe{
\item{\code{chr}}{ a \code{integer} representing a the chromosome from
fileBlock.
}
\item{\code{block.snp}}{ a \code{array} of integer
representing the linkage disequilibrium block for
each SNV in the in the same order than the variant
in Population reference dataset.
}
}
}
\description{
The function create a vector of integer representing the linkage
disequilibrium block for each SNV in the in the same order
than the variant in Population reference dataset.
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Demo of Reference GDS file containing reference information
fileReferenceGDS <- file.path(dataDir, "PopulationReferenceDemo.gds")

## Demo of of output file det from the plink block
## command for chromosome 1
fileLdBlock <- file.path(dataDir, "block.sp.EUR.Ex.chr1.blocks.det")

listLdBlock <- RAIDS:::processBlockChr(fileReferenceGDS, fileLdBlock)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
