% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelicFraction_internal.R
\encoding{UTF-8}
\name{testEmptyBox}
\alias{testEmptyBox}
\title{Calculate imbalance region using specified heterozygote SNVs
separately and together}
\usage{
testEmptyBox(matCov, pCutOff = -3)
}
\arguments{
\item{matCov}{a \code{data.frame} containing only heterozygote SNVs. The
\code{data.frame} must contain those columns:
\describe{
\item{cnt.ref}{ a single \code{integer} representing the coverage for
the reference allele.}
\item{cnt.alt}{ a single \code{integer} representing the coverage for
the alternative allele.}
}}

\item{pCutOff}{a \code{numeric} representing the cut-off for considering
a region imbalanced when comparing likelihood to be imbalanced and
likelihood not to be imbalanced. Default: \code{-3}.}
}
\value{
a \code{list} containing 4 entries:
\describe{
\item{pWin}{ a \code{vector} of \code{numeric} representing the
probability (x2) of obtaining the current
alternative/(alternative+reference) ratio from a 0.5 distribution.}
\item{p}{ a \code{numeric} representing the likelihood for the region}
\item{pCut}{ a \code{integer} indicating if all SNVs tested
positive (1=TRUE, 0=FALSE). The cut-off is 0.5. }
\item{pCut1}{ a \code{integer} indicating if the window tested
positive (1=TRUE, 0=FALSE) for imbalance.}
}
}
\description{
The function tests imbalance region using all specified SNVs
separately and together. The function reports the associated results,
including statistic for the region.
}
\examples{

## Data frame with SNV information for a list of heterozygote SNVs
snpInfo <- data.frame(
    cnt.ref=c(40, 17, 27, 15, 4, 14, 16, 32),
    cnt.alt=c(2, 4, 5, 10, 7, 23, 0, 0))

## Calculate imbalance for the region represented by the SNVs
RAIDS:::testEmptyBox(matCov=snpInfo, pCutOff=-3)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
