% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateDataRefSynParameter}
\alias{validateDataRefSynParameter}
\title{Validate that the reference profile data set has
the mandatory columns}
\usage{
validateDataRefSynParameter(syntheticRefDF)
}
\arguments{
\item{syntheticRefDF}{a \code{data.frame} containing a subset of
reference profiles for each sub-population present in the Reference GDS
file. The mandatory columns are:
"sample.id", "pop.group", "superPop". All columns must be in
\code{character} strings (no factor).}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input reference profile data set.
The reference profile data set
must be a \code{data.frame} with those mandatory columns:
"sample.id", "pop.group", "superPop". All columns must be in
\code{character} strings (no factor).
}
\examples{

## Profiles used for synthetic data set
syntheticRefDF <- data.frame(sample.id=c("HG00150", "HG00138", "HG00330",
    "HG00275"), pop.group=c("GBR", "GBR","FIN", "FIN"),
    superPop=c("EUR", "EUR", "EUR", "EUR"), stringsAsFactors=FALSE)

## Return 0L when the reference profile data set is valid
RAIDS:::validateDataRefSynParameter(syntheticRefDF=syntheticRefDF)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
