% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validatePruningSample}
\alias{validatePruningSample}
\title{Validate input parameters for pruningSample() function}
\usage{
validatePruningSample(
  gdsReference,
  method,
  currentProfile,
  studyID,
  listSNP,
  slideWindowMaxBP,
  thresholdLD,
  np,
  verbose,
  chr,
  superPopMinAF,
  keepPrunedGDS,
  pathProfileGDS,
  keepFile,
  pathPrunedGDS,
  outPrefix
)
}
\arguments{
\item{gdsReference}{an object of class \link[gdsfmt]{gds.class}
(a GDS file), the Population Reference GDS file.}

\item{method}{a \code{character} string that represents the method that will
be used to calculate the linkage disequilibrium in the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function.}

\item{currentProfile}{a \code{character} string
corresponding to the profile identifier used in LD pruning done by the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function. A Profile GDS file
corresponding to the profile identifier must exist and be located in the
\code{pathProfileGDS} directory.}

\item{studyID}{a \code{character} string corresponding to the study
identifier used in the \code{\link[SNPRelate]{snpgdsLDpruning}} function.
The study identifier must be present in the Profile GDS file.}

\item{listSNP}{a \code{vector} of SNVs identifiers specifying selected to
be passed the the pruning function;
if \code{NULL}, all SNVs are used in the
\code{\link[SNPRelate]{snpgdsLDpruning}} function.}

\item{slideWindowMaxBP}{a single positive \code{integer} that represents
the maximum basepairs (bp) in the sliding window. This parameter is used
for the LD pruning done in the \code{\link[SNPRelate]{snpgdsLDpruning}}
function.}

\item{thresholdLD}{a single \code{numeric} value that represents the LD
threshold used in the \code{\link[SNPRelate]{snpgdsLDpruning}} function.}

\item{np}{a single positive \code{integer} specifying the number of
threads to be used.}

\item{verbose}{a \code{logicial} indicating if information is shown
during the process in the \code{\link[SNPRelate]{snpgdsLDpruning}}
function.}

\item{chr}{a \code{character} string representing the chromosome where the
selected SNVs should belong. Only one chromosome can be handled. If
\code{NULL}, the chromosome is not used as a filtering criterion.}

\item{superPopMinAF}{a single positive \code{numeric} representing the
minimum allelic frequency used to select the SNVs. If \code{NULL}, the
allelic frequency is not used as a filtering criterion.}

\item{keepPrunedGDS}{a \code{logicial} indicating if the information about
the pruned SNVs should be added to the GDS Sample file.}

\item{pathProfileGDS}{a \code{character} string representing the directory
where the Profile GDS files will be created. The directory must exist.}

\item{keepFile}{a \code{logical} indicating if RDS files containing the
information about the pruned SNVs must be created.}

\item{pathPrunedGDS}{a \code{character} string representing an existing
directory. The directory must exist.}

\item{outPrefix}{a \code{character} string that represents the prefix of the
RDS files that will be generated. The RDS files are only generated when
the parameter \code{keepFile}=\code{TRUE}.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{pruningSample}} function.
}
\examples{

## Required library
library(gdsfmt)

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG GDS file (opened)
gds1KG <- openfn.gds(file.path(dataDir,
            "PopulationReferenceDemo.gds"), readonly=TRUE)

## The validation should be successful
RAIDS:::validatePruningSample(gdsReference=gds1KG, method="corr",
     currentProfile="TGCA_01", studyID="TCGA",
     listSNP=c("sr10103", "sr10202"), slideWindowMaxBP=1000L,
     thresholdLD=0.008, np=1L, verbose=TRUE, chr=1,
     superPopMinAF=0.002, keepPrunedGDS=TRUE, pathProfileGDS=dataDir,
     keepFile=FALSE, pathPrunedGDS=dataDir, outPrefix="test")

## All GDS file must be closed
closefn.gds(gdsfile=gds1KG)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
