% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{runReport}
\alias{runReport}
\title{Generate a RCAS Report for a list of transcriptome-level segments}
\usage{
runReport(
  queryFilePath = "testdata",
  gffFilePath = "testdata",
  annotationSummary = TRUE,
  goAnalysis = TRUE,
  motifAnalysis = TRUE,
  genomeVersion = "hg19",
  outDir = getwd(),
  printProcessedTables = FALSE,
  sampleN = 0,
  quiet = FALSE,
  selfContained = TRUE
)
}
\arguments{
\item{queryFilePath}{a BED format file which contains genomic coordinates of 
protein-RNA binding sites}

\item{gffFilePath}{A GTF format file which contains genome annotations 
(preferably from ENSEMBL)}

\item{annotationSummary}{TRUE/FALSE (default: TRUE) A switch to decide if 
RCAS should provide annotation summaries from overlap operations}

\item{goAnalysis}{TRUE/FALSE (default: TRUE) A switch to decide if RCAS 
should run GO term enrichment analysis}

\item{motifAnalysis}{TRUE/FALSE (default: TRUE) A switch to decide if RCAS 
should run motif analysis}

\item{genomeVersion}{A character string to denote for which genome version 
the analysis is being done.}

\item{outDir}{Path to the output directory. (default: current working 
directory)}

\item{printProcessedTables}{boolean value (default: FALSE). If set to TRUE, 
raw data tables that are used for plots/tables will be printed to text
files.}

\item{sampleN}{integer value (default: 0). A parameter to determine if the 
input query regions should be downsampled to a smaller size in order to 
make report generation quicker. When set to 0, downsampling won't be done. 
To activate the sampling a positive integer value that is smaller than the
total number of query regions should be given.}

\item{quiet}{boolean value (default: FALSE). If set to TRUE, progress bars 
and chunk labels will be suppressed while knitting the Rmd file.}

\item{selfContained}{boolean value (default: TRUE). By default, the generated
html file will be self-contained, which means that all figures and tables 
will be embedded in a single html file with no external dependencies 
(See rmarkdown::html_document)}
}
\value{
An html generated using rmarkdown/knitr/pandoc that contains 
  interactive figures, tables, and text that provide an overview of the 
  experiment
}
\description{
This is the main report generation function for RCAS. This function takes a
BED file, a GTF file to create a summary report regarding the annotation data
that overlap the input BED file, enrichment analysis for functional terms,
and motif analysis.
}
\examples{
#Default run will generate a report using built-in test data for hg19 genome.
\dontrun{
runReport()
}

#A custom run for human
\dontrun{
runReport( queryFilePath = 'input.BED',
           gffFilePath = 'annotation.gtf', 
           genomeVersion = 'hg19')
           }
# To turn off certain modules of the report
\dontrun{
runReport( queryFilePath = 'input.BED',
           gffFilePath = 'annotation.gtf',
           motifAnalysis = FALSE,
           goAnalysis = FALSE )
           }
}
