% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-TableColumns.R
\name{updateCyTableColumn}
\alias{updateCyTableColumn}
\alias{updateCyTableColumn.CyTableColumnAspect}
\alias{updateCyTableColumn.RCX}
\title{Update Cytoscape table column properties}
\usage{
updateCyTableColumn(
  x,
  cyTableColumns,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyTableColumn}{CyTableColumnAspect}(
  x,
  cyTableColumns,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyTableColumn}{RCX}(
  x,
  cyTableColumns,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CyTableColumn}} object; (to which the new table column properties will be added)}

\item{cyTableColumns}{\code{\link{CyTableColumn}} object; (the new aspect, that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \emph{appliesTo} and \emph{name}` (and \emph{subnetworkId} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{CyTableColumn}} or \link[=RCX-object]{RCX} object with added hidden attributes
}
\description{
This functions add hidden attributes in the form of a \code{\link{CyTableColumn}} object to an other \code{\link{CyTableColumn}} or an
\link[=RCX-object]{RCX} object.
}
\details{
In the case, that a \code{\link{CyTableColumn}} object is added to an other, or the \link[=RCX-object]{RCX} object already contains a
\code{\link{CyTableColumn}} object, some properties might be present in both. By default, the properties are updated with the values
of the latest one. This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.

Furthermore, if duplicated properties are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated properties are present.

Cytoscape does not currently support table columns for the root network, but this is option is included here for consistency.
}
\examples{
## For CyTableColumnssAspects: 
## prepare some aspects:
tableColumn1 = createCyTableColumn(
  appliesTo=c("nodes","edges","networks"),
  name=c("weight","weight","collapsed"),
  dataType=c("numeric","double","logical"),
  isList=c(FALSE,FALSE,TRUE),
  subnetworkId=c(NA,NA,1)
)

## nodes is updated, networks is new
tableColumn2 = createCyTableColumn(
  appliesTo=c("nodes","networks"),
  name=c("weight","collapsed"),
  dataType=c("double","character")
)

## Simply update with new values
tableColumn3 = updateCyTableColumn(tableColumn1, tableColumn2)

## Ignore already present keys
tableColumn3 = updateCyTableColumn(tableColumn1, tableColumn2, 
                                replace=FALSE)

## Raise an error if duplicate keys are present
try(updateCyTableColumn(tableColumn1, tableColumn2, 
                     stopOnDuplicates=TRUE))
## =>ERROR: 
## Elements of "appliesTo", "name" and "subnetworkId" (in updateCyTableColumn) 
## must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## add a table column property
rcx = updateCyTableColumn(rcx, tableColumn1)

## add an additional property (update with new values)
rcx = updateCyTableColumn(rcx, tableColumn2)

## create a prpperty with a not existing subnetwork...
tableColumn3 = createCyTableColumn(
  appliesTo="nodes",
  name="weight",
  subnetworkId=9
)

## ...and try to add them
try(updateCyTableColumn(rcx, tableColumn3))
## =>ERROR: 
## Provided IDs of "additionalColumns$subnetworkId" (in addCyTableColumn) 
## don't exist in "rcx$cySubNetworks$id"
}
\seealso{
\code{\link{CySubNetworks}}
}
