% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{hideEdges,RCyjs-method}
\alias{hideEdges,RCyjs-method}
\alias{hideEdges}
\title{hideEdges}
\usage{
\S4method{hideEdges}{RCyjs}(obj, edgeType)
}
\arguments{
\item{obj}{an RCyjs instance}

\item{edgeType}{a character string}
}
\value{
no return value
}
\description{
\code{hideEdges} hide all edges of the specified type
}
\details{
edgeType is a crucial feature for RCyjs.  We assume it is an attribute found
on every edge in every graph.
}
\examples{
if(interactive()){
   rcy <- RCyjs(title="rcyjs demo", graph=simpleDemoGraph())
   getNodes(rcy)
   edaNames(rcy)        # includes "edgeType"
   eda(rcy, "edgeType")  # includes "phosphorylates"
   hideEdges(rcy, edgeType="phosphorylates")
   showEdges(rcy, edgeType="phosphorylates")
   }
}
