% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_07_Integration.R
\name{runOmicsIntegration,RflomicsMAE-method}
\alias{runOmicsIntegration,RflomicsMAE-method}
\alias{runOmicsIntegration}
\alias{getMixOmics,RflomicsMAE-method}
\alias{getMixOmics}
\alias{getMOFA,RflomicsMAE-method}
\alias{getMOFA}
\alias{getMOFASettings,RflomicsMAE-method}
\alias{getMOFASettings}
\alias{getMixOmicsSettings,RflomicsMAE-method}
\alias{getMixOmicsSettings}
\alias{setMOFA,RflomicsMAE-method}
\alias{setMOFA}
\alias{setMixOmics,RflomicsMAE-method}
\alias{setMixOmics}
\alias{sumMixOmics,RflomicsMAE-method}
\alias{sumMixOmics}
\title{runOmicsIntegration}
\usage{
\S4method{runOmicsIntegration}{RflomicsMAE}(
  object,
  preparedObject = NULL,
  method = "MOFA",
  scale_views = FALSE,
  maxiter = 1000,
  num_factors = 10,
  selectedResponse = NULL,
  ncomp = 2,
  link_datasets = 1,
  link_response = 1,
  sparsity = FALSE,
  cases_to_try = 5,
  cmd = FALSE,
  ...
)

\S4method{getMixOmics}{RflomicsMAE}(object, response = NULL, onlyResults = TRUE)

\S4method{getMOFA}{RflomicsMAE}(object, onlyResults = TRUE)

\S4method{getMOFASettings}{RflomicsMAE}(object)

\S4method{getMixOmicsSettings}{RflomicsMAE}(object)

\S4method{setMOFA}{RflomicsMAE}(object, results = NULL)

\S4method{setMixOmics}{RflomicsMAE}(object, results = NULL)

\S4method{sumMixOmics}{RflomicsMAE}(object, selectedResponse = NULL)
}
\arguments{
\item{object}{a RflomicsMAE object.}

\item{preparedObject}{An untrained MOFA object or a list of dataset.
Usually a result of prepareForIntegration.}

\item{method}{one of MOFA or mixOmics.
Method for which the object is prepared.}

\item{scale_views}{boolean. If TRUE, scale each dataset to unit variance.}

\item{maxiter}{MOFA2 parameter.
Number of max iteration (otherwise stop when converged.)}

\item{num_factors}{MOFA2 parameter. The number of factor to compute.}

\item{selectedResponse}{a character.
Useful if MixOmics was run on several response variable.
If NULL, all variables are taken into account.}

\item{ncomp}{mixOmics parameter. Number of components to compute.}

\item{link_datasets}{mixOmics parameter.
Link between datasets in the computation.}

\item{link_response}{mixOmics parameter. Link between dataset and response.}

\item{sparsity}{boolean. Used to determine which mixOmics function to apply (either
block.plsda if FALSE or block.splsda if TRUE).}

\item{cases_to_try}{integer. If sparsity is set to TRUE, then cases_to_try
is used to determine the number of sets of variables to test for tuning.}

\item{cmd}{boolean. Used in the interface. If TRUE, print cmd in the console.}

\item{...}{not in use at the moment}

\item{response}{a character giving the response variable to access
specifically.}

\item{onlyResults}{default return only the MixOmics or MOFA2 results.
If you want to access all information of the integration,
set onlyResults to FALSE.
In MixOmics case, works only when response is specified.}

\item{results}{The MOFA or mixOmics results to set in the object.
If null, set to NULL.}
}
\value{
a RflomicsMAE object with the correct metadata slot filled with the
results and the settings.

For getters:
in getMixOmics, if response is NULL,
then all the mixOmics results are returned.
Otherwise, it gives the particular mixOmics result.
For MOFA, returns the untrained object and the trained object as a list.

For setters: always returns a \link{RflomicsMAE-class} object.

sumMixOmics: A data frame or a list of dataframe
(if selectedResponse is NULL) presenting the summary of mixOmics analyses.
}
\description{
Runs the integration according to the selected method (MOFA or
mixOmics) and the settings given by the user. Requires to have the correct
entry format in preparedObject before running.

These methods are used to directly access the results of multi-omics
analyses or their settings, usually stored in the metadata of the
\link{RflomicsMAE-class} object. Setters are also available.
}
\examples{
# load ecoseed data
library(RFLOMICS)
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

formulae <- generateModelFormulae( MAE) 
MAE <- setModelFormula(MAE, formulae[[1]])
contrastList <- Reduce(rbind, generateExpressionContrast(MAE)) 

MAE <- MAE |>
  setSelectedContrasts(contrastList[c(3,6,25)]) |>
  runDataProcessing(SE.name = "metatest", 
                    transformMethod = "log2",
                    normMethod = "median") |>
  runDataProcessing(SE.name = "protetest", 
                    transformMethod = "none",
                    normMethod = "median")   |>
  runDiffAnalysis(SE.name = "metatest", method = "limmalmFit")     |>
  runDiffAnalysis(SE.name = "protetest", method = "limmalmFit")    

# Integration using MOFA
# Prepare mofa object:
mofaObj <- prepareForIntegration(MAE,
                                 omicsNames = c("protetest", "metatest"),
                                 variableLists = rownames(MAE), 
                                 method = "MOFA")

# Perform integration: 
# Not run: MAEtest <- runOmicsIntegration(MAE, 
#                                preparedObject = mofaObj, 
#                                method = "MOFA", num_factors = 5)

# Integration using MixOmics
mixObj <- prepareForIntegration(MAE,
                                omicsNames = c("protetest", "metatest"),
                                variableLists = rownames(MAE),
                                method = "mixOmics")
MAEtest <- runOmicsIntegration(MAE, preparedObject = mixObj, 
                               method = "mixOmics")


# Access mixOmics results:
#getMixOmics(MAEtest, response = "temperature")
getMixOmicsSettings(MAEtest)
# mixOmics::plotIndiv(getMixOmics(MAEtest, response = "imbibition"))

# Access MOFA2 results:
# getMOFA(MAEtest)
# getMOFASettings(MAEtest)
# MOFA2::plot_variance_explained(getMOFA(MAEtest))

}
