% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectrumClasses.R
\docType{class}
\name{RmbSpectrum2-class}
\alias{RmbSpectrum2-class}
\alias{.RmbSpectrum2}
\title{RMassBank Representation of an MSMS Spectrum}
\description{
This extends the \code{Spectrum2} class of the \code{MSnbase}
package and introduces further slots that are used to store information
during the \code{RMassBank} workflow.
}
\section{Slots}{

\describe{
\item{\code{satellite}}{logical
If \code{TRUE}, the corresponding peak was removed as satellite.}

\item{\code{low}}{logical
If \code{TRUE}, the corresponding peak was removed
because it failed the intensity cutoff.}

\item{\code{rawOK}}{logical
If \code{TRUE}, the peak passed satellite and low-intensity cutoff removal.}

\item{\code{good}}{logical
If \code{TRUE}, a formula could be found for the peak
and the peak passed all filter criteria. (see the
\code{RMassBank} vignette or the documentation of \code{\link{analyzeMsMs}}#' for details on filter settings)}

\item{\code{mzCalc}}{numeric
The mz value calculated from the found formula for each peak (if any)}

\item{\code{formula}}{character
The formula found for each peak.
\code{\link[rcdk]{generate.formula}} is used
for formula-fitting}

\item{\code{dbe}}{numeric
The number of double bond equivalents.
This is calculated from the found formula for each peak (if any)}

\item{\code{formulaCount}}{integer
The number of different formulae found for each peak.
Note: A peak for which multiple formulas were found will appear
multiple times. Hence there may be multiple entries in the \code{formula}
, \code{dppm} and \code{mzCalc} slot for the same mz value.}

\item{\code{formulaSource}}{character "analyze" or "reanalysis"
Shows whether the current formula for the peak was determined by normal
analysis ("analyze") or by reanalysis of a failpeak ("reanalysis")}

\item{\code{dppm}}{numeric
The ppm deviation of the mz value from the found formula (if any).}

\item{\code{dppmBest}}{numeric
The ppm deviation of the mz value from the best formula found.}

\item{\code{ok}}{logical one-element vector
If this is \code{TRUE}, the spectrum was successfully processed
with at least one resulting peak.
Otherwise, one of the following cases applies:
\itemize{
\item All peaks failed the intensity cutoff
i.e. the whole spectrum contains low intensity peaks, only.
\item All peaks were marked as satellites.
\item All peaks in the spectrum have a lower intensity than the value
given in the \code{specOkLimit} filter setting. (see the \code{RMassBank}
vignette or the documentation of \code{\link{analyzeMsMs}})
\item The precursor ion formula is invalid (see \code{\link{is.valid.formula}})
\item The spectrum is empty.
\item No molecular formula could be found for any of the peaks.
\item All peaks failed the \code{dbeMinLimit} criterion. (see the
\code{RMassBank} vignette or the documentation of \code{\link{analyzeMsMs}})
}}

\item{\code{info}}{list
Spectrum identifying information
(collision energy, resolution, collision mode) from the \code{spectraList}}

\item{\code{properties}}{data.frame
This is used as a flexible placeholder to store additional properties
for each peak throughout the workflow. After the last step of the
\code{mbWorkflow}, this will typically contain columns \code{mzRaw},
\code{noise}, \code{formulaMultiplicity}, \code{bestMultiplicity}
and \code{filterOK}. However, new columns may be added on demand
(see \code{\link{property<-}})}
}}

\seealso{
\code{\link[rcdk]{generate.formula}}, \code{\link{property<-}}
\code{\link{analyzeMsMs}}, \code{\link{generate.formula}},
\code{\link{is.valid.formula}}
}
