% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{toMassbank}
\alias{toMassbank}
\alias{toMassbank,RmbSpectraSet-method}
\alias{toMassbank,RmbSpectrum2-method}
\title{Write MassBank record into character array}
\usage{
toMassbank(o, ...)

\S4method{toMassbank}{RmbSpectraSet}(o, addAnnotation = getOption("RMassBank")$add_annotation)

\S4method{toMassbank}{RmbSpectrum2}(o, addAnnotation = getOption("RMassBank")$add_annotation)
}
\arguments{
\item{o}{An object to convert to MassBank record format. This may be
a single `RmbSpectrum2`, or a complete compound (an `RmbSpectraSet`),}

\item{...}{Parameters passed to the implementation, 
in particular `addAnnotation`}

\item{addAnnotation}{`logical`, whether to add peak annotations (putative formulas) to the record.}
}
\value{
The result is a text array, which is ready to be written to the disk
as a file.
}
\description{
Writes a MassBank record in list format to a text array.
}
\details{
The function is a general conversion tool for the MassBank format; i.e. the
field names are not fixed. \code{mbdata} must be a named list, and the
entries can be as follows: \itemize{
 \item A single text line:

\code{'CH\$EXACT_MASS' = '329.1023'}

 is written as

 \code{CH\$EXACT_MASS: 329.1023} 
\item A character array:

 \code{'CH\$NAME' = c('2-Aminobenzimidazole', '1H-Benzimidazol-2-amine')} 

is written as

\code{CH\$NAME: 2-Aminobenzimidazole}

\code{CH\$NAME: 1H-Benzimidazol-2-amine}

\item A named list of strings: 

	\code{'CH\$LINK' = list('CHEBI' = "27822", "KEGG" = "C10901")} 

is written as 

\code{CH\$LINK: CHEBI 27822}

\code{CH\$LINK: KEGG C10901} 

\item A data frame (e.g. the peak table) is written as specified in
the MassBank record format (Section 2.6.3): the column names are used as
headers for the first line, all data rows are printed space-separated. 
}
}
\note{
The function iterates over the list item names. \bold{This means that
duplicate entries in \code{mbdata} are (partially) discarded!} The correct
way to add them is by making a character array (as specified above): Instead
of \code{'CH\$NAME' = 'bla', 'CH\$NAME' = 'blub'} specify \code{'CH\$NAME' =
c('bla','blub')}.
}
\examples{
\dontrun{
# Read just the compound info skeleton from the Internet for some compound ID
id <- 35
mbdata <- gatherData(id)
#' # Export the mbdata blocks to line arrays 
# (there is no spectrum information, just the compound info...)
mbtext <- toMassbank(mbdata)
}


}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{buildRecord}}, \code{\link{mbWorkflow}}
}
\author{
Michael Stravs
}
