# RNAmodR.RiboMethSeq [![Build Status](https://travis-ci.com/FelixErnst/RNAmodR.RiboMethSeq.svg?branch=master)](https://travis-ci.com/FelixErnst/RNAmodR.RiboMethSeq) [![codecov](https://codecov.io/gh/FelixErnst/RNAmodR.RiboMethSeq/branch/master/graph/badge.svg)](https://codecov.io/gh/FelixErnst/RNAmodR.RiboMethSeq)

`RNAmodR.RiboMethSeq` uses classes and workflows from `RNAmodR` to detect 2'-O
methylations from RiboMethSeq data.

The vignette from the `RNAmodR.RiboMethSeq` package provides details on the
specific analysis of RiboMethSeq data. Have a look at the vignette from the
`RNAmodR` package for a general description on the provided workflows.

# Installation

The current version of the RNAmodR.RiboMethSeq package is available from 
Bioconductor.

```
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")

# The following initializes usage of Bioc devel
BiocManager::install("RNAmodR.RiboMethSeq")
library(RNAmodR.RiboMethSeq)
```

# Literature

- Birkedal U, Christensen-Dalsgaard M, Krogh N, Sabarinathan R, Gorodkin J,
Nielsen H (2015): "Profiling of ribose methylations in RNA by high-throughput
sequencing." Angewandte Chemie (International ed. in English) 54 (2),
P. 451–455. DOI: 
[10.1002/anie.201408362](https://doi.org/10.1002/anie.201408362).

- Marchand V, Ayadi L, El Hajj A, Blanloeil-Oillo F, Helm M, Motorin Y
(2017): "High-Throughput Mapping of 2'-O-Me Residues in RNA Using
Next-Generation Sequencing (Illumina RiboMethSeq Protocol)." Methods in
molecular biology (Clifton, N.J.) 1562, P. 171–187. DOI:
[10.1007/978-1-4939-6807-7_12](https://doi.org/10.1007/978-1-4939-6807-7_12).

- Galvanin A, Ayadi L, Helm M, Motorin Y, Marchand V (2017): "Mapping and
Quantification of tRNA 2'-O-Methylation by RiboMethSeq". Wajapeyee N., Gupta
R. (eds) Epitranscriptomics. Methods in Molecular Biology (Humana Press,
New York, NY) 1870, P. 273-295. DOI:
[10.1007/978-1-4939-8808-2_21](https://doi.org/10.1007/978-1-4939-8808-2_21).
