% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toydata.R
\name{sample.probeset}
\alias{sample.probeset}
\title{sample.probeset}
\usage{
sample.probeset(P = 10, n = 20, shape = 1, scale = 1, mu.real = 2)
}
\arguments{
\item{P}{Number of probes.}

\item{n}{Number of samples.}

\item{shape}{Shape parameter of the inverse Gamma function used to generate the probe-specific variances.}

\item{scale}{Scale parameters of the inverse Gamma function used to generate the probe-specific variances.}

\item{mu.real}{Absolute signal level of the probeset.}
}
\value{
A list with the following elements:
\item{dat }{Probeset data: probes x samples}
\item{tau2 }{Probe variances.}
\item{affinity }{Probe affinities.}
\item{d }{Probeset signal shape.}
\item{mu.real }{Probeset signal level.}
\item{mu }{Probeset-level total signal.}
}
\description{
Toydata generator for probeset data.
}
\details{
Generate random probeset with varying probe-specific affinities and variances. The toy data generator follows distributional assumptions of the RPA model and allows quantitative estimation of model accuracy with different options, noise levels and sample sizes. Probeset-level summary estimate is obtained as mu.real + d.
}
\examples{
# real <- sample.probeset(P = 10, n = 20, shape = 1, scale = 1, mu.real = 2)
}
\references{
See citation("RPA")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
