% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.optimizeParameters.r
\name{plot.optimizeParameters}
\alias{plot.optimizeParameters}
\title{Plots an object of class \code{optimizeParameters}.}
\usage{
\method{plot}{optimizeParameters}(
  x,
  main = colnames(opt$All.results)[seq(3, dim(opt$All.results)[2], 1)],
  ...
)
}
\arguments{
\item{x}{An object of the class \code{optimizeParameters}.}

\item{main}{A character string describing title of plot.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{plot.optimizeParameters} returns a plot.
}
\description{
\code{plot.optimizeParameters} generates a heatmap of the quality assessment values
stored in the object of class \code{optimizeParameters} .
}
\details{
The black point in the heatmap denotes the optimal parameter combination.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=2, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
opt<-optimizeParameters(Y, kW.hat=c(1,5,10), nu.hat=c(100,100000), 
nc_index=seq(251,500,1), methods=c("fnorm"), cpus=1, parallel=FALSE)
try(dev.off(), silent=TRUE)
plot(opt, main="Heatmap Plot")
}
\seealso{
\code{\link{optimizeParameters}}
}
\author{
Saskia Freytag
}
