% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_motifAnnotations.R
\docType{data}
\name{motifAnnotations}
\alias{motifAnnotations}
\alias{motifAnnotations_hgnc}
\alias{motifAnnotations_mgi}
\alias{motifAnnotations_dmel}
\alias{motifAnnotations_hgnc_v9}
\alias{motifAnnotations_mgi_v9}
\alias{motifAnnotations_dmel_v9}
\alias{motifAnnotations_hgnc_v8}
\alias{motifAnnotations_mgi_v8}
\alias{motifAnnotations_dmel_v8}
\title{Annotations of Motifs to TFs}
\description{
\itemize{
\item{\bold{motifAnnotations_hgnc}: }{Annotations to \bold{HUMAN} transcription factors for 
  the rankings using motif collection version 10.
  Source: \emph{motifs-v10nr_clust-nr.hgnc-m0.001-o0.0.tbl}}
 
\item{\bold{motifAnnotations_mgi}: }{Contains the annotations to \bold{MOUSE} transcription factors for 
the rankings using motif collection version 10.
Source: \emph{motifs-v10nr_clust-nr.mgi-m0.001-o0.0.tbl}}

\item{\bold{motifAnnotations_dmel}: }{Contains the annotations to \bold{FLY} transcription factors for 
the rankings using motif collection version 10.
Source: \emph{motifs-v10nr_clust-nr.flybase-m0.001-o0.0.tbl}}
}
\bold{Previous versions}: 

Annotations for motif collection version 9 ('mc9nr').
\itemize{
    \item{Human: motifAnnotations_hgnc_v9 (\emph{motifs-v9-nr.hgnc-m0.001-o0.0.tbl}})
    \item{Mouse: motifAnnotations_mgi_v9 (\emph{motifs-v9-nr.mgi-m0.001-o0.0.tbl}})
    \item{Fly: motifAnnotations_dmel_v9 (\emph{motifs-v9-nr.flybase-m0.001-o0.0.tbl}})
    }
    
Annotations for motif collection version 8 ('mc8nr'). 
- Deprecated: Will be removed in upcoming versions of the package
\itemize{
    \item{Human: motifAnnotations_hgnc_v8 (\emph{motifs-v8-nr.hgnc-m0.001-o0.0.tbl}})
    \item{Mouse: motifAnnotations_mgi_v8 (\emph{motifs-v8-nr.mgi-m0.001-o0.0.tbl}})
    \item{Fly: motifAnnotations_dmel_v8 (\emph{motifs-v8-nr.flybase-m0.001-o0.0.tbl}})
    }


These objects are meant to be provided to RcisTarget without modification, 
but it can also be explored by the user 
to obtain further information about the motifs.
The original files can be downloaded from \code{https://resources.aertslab.org/cistarget/motif2tf/}
Columns:
\itemize{
 \item{\bold{motif}: }{Motif ID.}
 \item{\bold{TF}: }{Transcription factor (or inferred gene).}
 \item{\bold{directAnnotation}, \bold{inferred_Orthology}, 
       \bold{inferred_MotifSimil}: }
    {Boolean values indicating whether the motif is 
       annotated to the TF in the source database ("directAnnotation"), 
       or whether it was inferred by orthology ("inferred_Orthology") 
       or motif similarity ("inferred_MotifSimil").}
 \item{\bold{Description}: }{Description of the source of the annotation.}
   \item{\bold{annotationSource}: }{
     Source of the annotation formatted as factor (e.g. for subsetting). 
     Levels: directAnnotation, inferredBy_Orthology, 
     inferredBy_MotifSimilarity, inferredBy_MotifSimilarity_n_Orthology.}
}
}
\details{
Documentation for the data
}
\seealso{
importAnnotations, RcisTarget
}
\keyword{datasets}
