% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_sc_clusters.R
\name{analyse_sc_clusters,SingleCellExperiment-method}
\alias{analyse_sc_clusters,SingleCellExperiment-method}
\title{analyse_sc_clusters - SingleCellExperiment}
\usage{
\S4method{analyse_sc_clusters}{SingleCellExperiment}(
  object,
  use_interactors = TRUE,
  include_disease_pathways = FALSE,
  create_reactome_visualization = FALSE,
  create_reports = FALSE,
  report_email = NULL,
  verbose = FALSE,
  cell_ids,
  ...
)
}
\arguments{
\item{object}{The \code{SingleCellExperiment} object containing the single cell RNA-sequencing data.}

\item{use_interactors}{If set (default), protein-protein interactors from IntAct are used to
extend Reactome pathways.}

\item{include_disease_pathways}{If set, disease pathways are included as well. Disease pathways in
Reactome follow a different annotation approach and can therefore
lead to inaccurate results.}

\item{create_reactome_visualization}{If set, the interactive visualization in Reactome's PathwayBrowser
is created.}

\item{create_reports}{If set, PDF and Microsoft Excel reports are created. Links to these report files
are send to the supplied e-mail address.}

\item{report_email}{The e-mail address to which reports should be sent to.}

\item{verbose}{If set, additional status messages are printed.}

\item{cell_ids}{A factor specifying the group to which each cell belongs. For example, \code{object$cluster}. 
Alternatively, a string specifying the metada field's name may be passed.}

\item{...}{Parameters passed to scater's \code{aggregateAcrossCells} function.}
}
\value{
A \code{\link{ReactomeAnalysisResult}} object.
}
\description{
Analyses cell clusters of a single-cell RNA-sequencing
experiment to get pathway-level expressions for every
cluster of cells.
}
\details{
There are currently two specific implementations of
this function, one to support \code{Seurat} objects
and one to support Bioconductor's \code{SingleCellExperiment}
class.
}
\examples{
# This example shows how a Seurat object can be analysed
# the approach is identical for SingleCellExperiment objects
library(ReactomeGSA.data)
data(jerby_b_cells)

# perform the GSVA analysis
gsva_result <- analyse_sc_clusters(jerby_b_cells, verbose = FALSE)
}
