% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{addEdges,character-method}
\alias{addEdges,character-method}
\alias{addEdges}
\alias{addEdges,data.frame-method}
\title{addEdges}
\usage{
\S4method{addEdges}{character}(edges, ...)

\S4method{addEdges}{data.frame}(edges, ...)
}
\arguments{
\item{edges}{A vertex sequence <vector of strings> or data frame of ncol=2.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Add edges to an active RedeR session.
}
\description{
Add edges to an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create some edges as a vertex sequence
edges <- c("n1", "n2", "n1", "n3", "n1", "n4", "n1", "n5")

# ...or as a data.frame
edges <- data.frame(
    A = c("n1", "n1", "n1", "n1"),
    B = c("n2", "n3", "n4", "n5")
)

\donttest{
# Start the RedeR interface and add edges
startRedeR()
addEdges(edges)
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
