% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedGetGraphMethods.R
\docType{methods}
\name{getGraph,RedPort-method}
\alias{getGraph,RedPort-method}
\alias{getGraph}
\title{Get graphs from RedeR}
\usage{
\S4method{getGraph}{RedPort}(
  obj,
  status = c("all", "selected", "notselected"),
  attribs = c("all", "minimal"),
  type = c("node", "container", "all")
)
}
\arguments{
\item{obj}{A \code{RedPort}-class object.}

\item{status}{A filter (string) indicating the status of the graph elements
that should be fetched from the RedeR app (default='all').}

\item{attribs}{A filter (string) indicating the graph attributes
that should be fetched from the RedeR app (default='all').}

\item{type}{A filter (string) indicating the graph element types that
should be fetched from the RedeR app (default='node').}
}
\value{
igraph objects from RedeR.
}
\description{
Methods to wrap up RedeR graphs into igraph's R objects.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

g <- graph.lattice(c(5, 5, 5))

rdp <- RedPort()

\donttest{
calld(rdp)
addGraph(rdp, g, layout_nicely(g))
g <- getGraph(rdp)
}

}
\seealso{
\code{\link{getGraphFromRedeR}}
}
\author{
Sysbiolab.
}
