% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{selectNodes,character-method}
\alias{selectNodes,character-method}
\alias{selectNodes}
\title{selectNodes}
\usage{
\S4method{selectNodes}{character}(nodes, anchor = FALSE, nid = NULL, ...)
}
\arguments{
\item{nodes}{A string or array of strings with node names.}

\item{anchor}{A logical value, whether to anchor nodes, which will prevent
the \code{\link{relax}} function from applying the relaxing algorithm
on the selected nodes.}

\item{nid}{A nest ID. This will restrict searching to a specific container.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Mark nodes -- which can be handled by other methods.
}
\description{
Select nodes in an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create some edges as a data.frame
edges <- data.frame(
    A = c("n1", "n1", "n1", "n1"),
    B = c("n2", "n3", "n4", "n5")
)

\donttest{
# Start the RedeR interface
startRedeR()

# Add edges and select nodes
addEdges(edges)
selectNodes(c("n1", "n3"))
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
