% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateShift.R
\name{calculateShift}
\alias{calculateShift}
\title{Calculate positional shifting over transcriptome}
\usage{
calculateShift(regions, disp, direction = "right", strand = "+")
}
\arguments{
\item{regions}{A feature set, which should be a GRangesList object.}

\item{disp}{A data frame object. It should have three columns, which are \code{start}: starting positions. Each value represents a starting position in each input feature;
\code{width}: widths. Each value represents a width of each region to be picked from each feature; \code{names}: corresponding transcript ids.}

\item{direction}{Either to be character "left" or "right", which means the direction to which the starting position is shifting. The former means moving to the direction of 5' while the latter means moving to 3'.}

\item{strand}{Either to be "+" or "-".}
}
\value{
A \code{GRanges} object.
}
\description{
The first step of calculating positional shift over transcriptome regions.
}
\examples{
# Take five transcripts.
# Extract the last 200 nt regions from their CDS part.
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
trans.id.pstv <- c("170", "782", "974", "1364", "1387")
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene

# Download the CDS part of all transcriptome
cds.tx0 <- cdsBy(txdb, use.names = FALSE)

# pick the CDS part of these five transcripts
cds.p <- cds.tx0[trans.id.pstv]

width <- 200
disp.p.l <- data.frame(
    start = as.numeric(max(end(cds.p))),
    distance = width - 1,
    names = trans.id.pstv
)
R.p.l <- calculateShift(
    regions = cds.p, disp = disp.p.l,
    direction = "left", strand = "+"
)
}
\seealso{
\code{\link{extractRegions}}
}
