% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceTx.R
\name{distanceTx}
\alias{distanceTx}
\title{Evaluation function}
\usage{
distanceTx(A, B, beta = 0.2, ...)
}
\arguments{
\item{A}{Region set 1. A Granges or GRangesList object.}

\item{B}{Region set 2. A Granges or GRangesList object.}

\item{beta}{It is a user-defined argument that can filter out the corresponding percent of largest distance values. Default value is 0.2.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{numeric} object.
}
\description{
Evaluation function. This function calculates the mean of the distance from each region of set RS1 to the closest region in RS2.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
A <- randomizeTx(
    txdb, trans.ids,
    random_num = 20,
    random_length = 100
)
B <- randomizeTx(
    txdb, trans.ids,
    random_num = 20,
    random_length = 100
)
distanceTx(A, B, beta = 0.2)
}
\seealso{
\code{\link{overlapWidthTx}}, \code{\link{overlapCountsTx}}
}
