% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRegions.R
\name{extractRegions}
\alias{extractRegions}
\title{Extract regions}
\usage{
extractRegions(regions_A, R, strand = "+")
}
\arguments{
\item{regions_A}{The scope region set. A \code{GRangesList} object. The name of each list element should be the transcript id that it pertains to.}

\item{R}{The target region set. A \code{GRanges} object.}

\item{strand}{The strand type of the transcripts. It has options "+" and "-".}
}
\value{
A \code{GRangesList} object.
}
\description{
This function receives three arguments: the scope region set, the target region set and the type of strand. It returns a subset of target region set, which is the intersection of the target region set and the scope region set.
}
\examples{
# Take five transcripts.
# Extract the last 200 nt regions from their CDS part.
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
trans.id.pstv <- c("170", "782", "974", "1364", "1387")
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene

# download the CDS part of all transcriptome
cds.tx0 <- cdsBy(txdb, use.names = FALSE)

# pick the CDS part of these five transcripts
cds.p <- cds.tx0[trans.id.pstv]

width <- 200
disp.p.l <- data.frame(
    start = as.numeric(max(end(cds.p))),
    distance = width - 1,
    names = trans.id.pstv
)
R.p.l <- calculateShift(regions = cds.p, disp = disp.p.l, direction = "left", strand = "+")

R.cds.last200 <- extractRegions(regions_A = cds.p, R = R.p.l, strand = "+")
}
\seealso{
\code{\link{calculateShift}}
}
