% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapWidthTx.R
\name{overlapWidthTx}
\alias{overlapWidthTx}
\title{Evaluation function}
\usage{
overlapWidthTx(A, B, ...)
}
\arguments{
\item{A}{Region set 1. A \code{Granges} or \code{GRangesList} object.}

\item{B}{Region set 2. A \code{Granges} or \code{GRangesList} object.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{numeric} object.
}
\description{
Evaluation function. This function returns the sum of widths of each overlap between two region sets,  i.e., the total number of overlapping nucleotides between two input region sets.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
A <- randomizeTx(
    txdb, trans.ids, random_num = 20,
    random.length = 100
)
B <- randomizeTx(
    txdb, trans.ids = trans.ids, random_num = 20,
    random_length = 100
)

overlapWidthTx(A, B)
}
\seealso{
\code{\link{overlapCountsTx}}, \code{\link{distanceTx}}
}
