% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummarizedCov.R
\name{plotSummarizedCov}
\alias{plotSummarizedCov}
\title{Plots the summarized coverage in a specified range (e.g. around TSS)
for the specified match sizes}
\usage{
plotSummarizedCov(covSummarized)
}
\arguments{
\item{covSummarized}{a list of GRanges objects.
For each matchSize a GRanges object of the summarized coverage.}
}
\value{
a ggplot2 plot of read coverage in interval
}
\description{
Plots the summarized coverage in a specified range (e.g. around TSS)
for the specified match sizes
}
\examples{
#read the BAM file into a GAlignments object using
#GenomicAlignments::readGAlignments
#the GAlignments object should be similar to ctrlGAlignments
data(ctrlGAlignments)
aln <- ctrlGAlignments
#transform the GAlignments object into a GRanges object (faster processing)
alnGRanges <- readsToStartOrEnd(aln, what="start")
#make a txdb object containing the annotations for the specified species.
#In this case hg19.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene
#Please make sure that seqnames of txdb correspond to
#the seqnames of the alignment files ("chr" particle)
#if not rename the txdb seqlevels
#seqlevels(txdb) <- sub("chr", "", seqlevels(txdb))
#get the flanking region around the promoter of the best expressed CDSs
oneBinRanges <- aroundPromoter(txdb, alnGRanges)
#the read start coverage around the TSS as a percentage for all match sizes.
covSummarized <- readStartCov(alnGRanges, oneBinRanges, matchSize="all",
c(-20,20), "aroundTSS", charPerc="perc")
trackPlotTSS <- plotSummarizedCov(covSummarized)
print(trackPlotTSS)
}
