% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBiseqSet-class.R
\docType{class}
\name{RnBiseqSet-class}
\alias{RnBiseqSet-class}
\alias{RnBiseqSet}
\alias{initialize,RnBiseqSet-method}
\title{RnBiseqSet Class}
\usage{
RnBiseqSet(
  pheno,
  sites,
  meth,
  covg = NULL,
  assembly = "hg19",
  target = "CpG",
  summarize.regions = TRUE,
  region.types = rnb.region.types.for.analysis(assembly),
  useff = rnb.getOption("disk.dump.big.matrices"),
  usebigff = rnb.getOption("disk.dump.bigff"),
  verbose = FALSE
)
}
\arguments{
\item{pheno}{phenotypic data.}

\item{sites}{CpG site definition, as a \code{data.frame}
with 3 variables: chromosome (of type
\code{character}), position (\code{integer}) and
strand (\code{character}, one of \code{"+"}, \code{"-"} or \code{"*"}}

\item{meth}{summarized methylation calls as a \code{matrix} or \code{ff_matrix}}

\item{covg}{read coverage information as a \code{matrix} or \code{ff_matrix}}

\item{assembly}{the genome assembly}

\item{target}{target DNA methylation features (CpG sites)}

\item{summarize.regions}{...}

\item{region.types}{region annotations for which the methylation data should be summarized}

\item{useff}{flag specifying whether the ff functionality should be used}

\item{usebigff}{flag specifying whether the extended ff functionality should be used (large matrix support for ff)}

\item{verbose}{flag specifying whether the diagnostic messages should be written to the 
console or to the RnBeads logger, if the latter is initialized}
}
\value{
an object of class RnBiseqSet
}
\description{
A class for storing the DNA methylation and quality information from bisulfite sequencing experiments
}
\details{
TBA
}
\section{Slots}{

\describe{
  \item{\code{status}}{Normalization status.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{\link[BiocGenerics]{combine}}}{Combines two datasets.}
}
}

\author{
Pavlo Lutsik
}
