% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.RnBSet.to.bedGraph}
\alias{rnb.RnBSet.to.bedGraph}
\title{rnb.RnBSet.to.bedGraph}
\usage{
rnb.RnBSet.to.bedGraph(
  rnb.set,
  out.dir = ".",
  reg.type = "sites",
  parameters = character(),
  digits = NULL
)
}
\arguments{
\item{rnb.set}{Dataset as an instance of class \code{\linkS4class{RnBSet}}.}

\item{out.dir}{One-element \code{character} vector signifying the output directory in which to create
\code{bedGraph} files. Setting this to \code{"."} (default) uses the current working directory. If
the output directory does not exist, this function attempts to create it. Any existing files in
this directory could be overwritten.}

\item{reg.type}{Site or region type to be exported.}

\item{parameters}{Named \code{character} vector storing parameters (other than \code{"type"} and \code{"name"}) to
include in the track definition line. The names of this vector must be the parameter names, and its
elements - the corresponding values; missing values (\code{NA}s) are allowed neither for names, nor
for values. This function does not test if all provided parameter names and values conform to the
BedGraph track specification.}

\item{digits}{Optionally, number of significant digits after the decimal point to round methylation values to. If
specified, this parameter must be an \code{integer} between \code{0} and \code{10}.}
}
\value{
(invisibly) a summary list containing information on the conversion step.
        elements are \code{filenames} (a table containing information on which sample has been written to what filename)
        and \code{assembly} (a string indicating the assembly used by \code{rnb.set}).
}
\description{
Exports the methylation data of an \code{\linkS4class{RnBSet}} object to \code{*.bedGraph} files.
}
\details{
The description of the BedGraph track format can be found \href{http://genome.ucsc.edu/goldenPath/help/bedgraph.html}{here}.
         Each methylation site is an entry in the resulting bedGraph file. The Score column corresponds to a site's
         methylation value in the interval \code{[0,1]}.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.RnBSet.to.bedGraph(rnb.set.example,tempdir())
}
}
\author{
Fabian Mueller
}
