% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rnb.build.index}
\alias{rnb.build.index}
\title{rnb.build.index}
\usage{
rnb.build.index(
  dir.reports,
  fname = "index.html",
  dir.configuration = "configuration",
  open.index = TRUE
)
}
\arguments{
\item{dir.reports}{Directory that contains HTML reports generated by \pkg{RnBeads} modules. If this directory
does not exist, is a regular file, is inaccessible, or does not contain any recognizable
HTML report files, this function does not generate an HTML index file and produces an error
or a warning message.}

\item{fname}{One-element \code{character} vector specifying the name of the index file to be generated.
See the \emph{Details} section for restrictions on the name. The file will be created in
\code{dir.reports}. If such a file already exists, it will be overwritten.}

\item{dir.configuration}{Subdirectory that hosts configuration files shared by the reports. This must be a
\code{character} vector of length one that gives location as a path relative to
\code{dir.reports}. Strong restrictions apply to the path name. See the description of the
\code{\link{createReport}} function for more details.}

\item{open.index}{Flag indicating if the index should be displayed after it is created. If this is
\code{TRUE}, \code{\link{rnb.show.report}} is called to open the generated HTML file.}
}
\value{
Names of all HTML report files that were referenced in the newly generated index, invisibly. The order of the
        file names is the same as the one they are listed in the index. If no known reports are found in the given
        directory, the returned value is an empty \code{character} vector.
}
\description{
Creates an HTML index file that contains listing of all available \pkg{RnBeads} reports. If no known reports are
found in the specified directory, no index is created.
}
\details{
In order to ensure independence of the operating system, there are strong restrictions on the name of the index file.
It can consist of the following symbols only: Latin letters, digits, dot (\code{.}), dash (\code{-}) and underline
(\code{_}). The extension of the file must be one of \code{htm}, \code{html}, \code{xhtml} or \code{xml}. The name
must not include paths, that is, slash (\code{/}) or backslash (\code{\\}) cannot be used. In addition, it cannot be
any of the recognized \pkg{RnBeads} report file names.
}
\seealso{
\code{\link{rnb.run.analysis}}, \code{\link{rnb.initialize.reports}}
}
\author{
Yassen Assenov
}
