% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{rnb.execute.normalization}
\alias{rnb.execute.normalization}
\title{rnb.execute.normalization}
\usage{
rnb.execute.normalization(
  object,
  method = rnb.getOption("normalization.method"),
  bgcorr.method = rnb.getOption("normalization.background.method"),
  verbose = TRUE
)
}
\arguments{
\item{object}{Methylation dataset as an object of type \code{\linkS4class{MethyLumiSet}} or
\code{\linkS4class{RnBSet}}.}

\item{method}{Normalization method, must be one of \code{"none"}, \code{"illumina"}, \code{"swan"},
\code{"minfi.funnorm"}, \code{"bmiq"}, or \code{wm.*} where \code{*} stands for one of the methods
implemented in \pkg{wateRmelon} package.
Note that the execution of methods SWAN and minfi.funnorm requires packages \pkg{minfi} and
\pkg{IlluminaHumanMethylation450kmanifest}. The BMIQ method requires the package \pkg{RPMM}. The
\code{wm.*} methods naturally require \pkg{wateRmelon}.}

\item{bgcorr.method}{Character singleton specifying which background subtraction should be used. Only methods impemented
in the \pkg{methylumi} package are supported at the moment, namely \code{methylumi.noob}, \code{methylumi.goob}
and \code{methylumi.doob}. See Triche et al. for detailed description of the methods.}

\item{verbose}{flag specifying whether diagnostic output should be written to the console or to the RnBeads logger
in case the latter is initialized}
}
\value{
Normalized dataset as an object of type \code{\linkS4class{RnBeadSet}}.
}
\description{
Performs normalization of the provided HumanMethylation450 data set.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.set.norm<-rnb.execute.normalization(rnb.set.example, method="illumina", bgcorr.method="none")
}
}
\references{
1. Triche, Timothy J., Jr., Weisenberger, Daniel J., Van Den Berg, David, Laird, Peter W. and Siegmund, Kimberly D. (2013)
            Low-level processing of Illumina Infinium DNA Methylation BeadArrays.
            Nucleic Acids Research 41(7):e90-e90.
}
\author{
Pavlo Lutsik
}
