% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.variability.removal}
\alias{rnb.execute.variability.removal}
\title{rnb.execute.variability.removal}
\usage{
rnb.execute.variability.removal(
  rnb.set,
  min.deviation = rnb.getOption("filtering.deviation.threshold")
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{min.deviation}{Threshold for standard deviation per site. This must be a scalar between 0 and 1. All sites, for
which the standard deviation of methylation values (for all samples in \code{rnb.set}) is lower
than this threshold, will be filtered out.}
}
\value{
List of four elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly modified) dataset after removing sites with low variability.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices (in beta matrix of the unfiltered
               dataset) of all removed sites.}
			 \item{\code{"threshold"}}{The value of the given parameter \code{min.deviation}.}
        }
}
\description{
Removes all sites or probes with low variability from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.filtered <- rnb.execute.variability.removal(rnb.set.example, 0.01)
}
}
\author{
Yassen Assenov
}
