% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.get.directory}
\alias{rnb.get.directory}
\title{rnb.get.directory}
\usage{
rnb.get.directory(
  report,
  dir = c("data", "images", "images-high", "pdfs"),
  absolute = FALSE
)
}
\arguments{
\item{report}{Report of interest.}

\item{dir}{Type of directory to get. Must be one of \code{"data"}, \code{"images"}, \code{"images-high"} or
\code{"pdfs"}.}

\item{absolute}{Flag indicating if the absolute path of the directory is to be returned. If this is \code{FALSE},
the directory name is returned relative to the report's HTML file location.}
}
\value{
Path of the requested directory as a single-element \code{character} vector.
}
\description{
Gets the location of the given report-specific directory.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
rnb.get.directory(report, "data")
}
}
\seealso{
\code{\linkS4class{Report}} for functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
