% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.load.annotation}
\alias{rnb.load.annotation}
\title{rnb.load.annotation}
\usage{
rnb.load.annotation(fname, type)
}
\arguments{
\item{fname}{One-element \code{character} vector giving the name of the file that contains the annotation data.}

\item{type}{One-element \code{character} vector giving the name of the region annotation. If this annotation
is already available, it will be overwritten for the current session.}
}
\value{
Invisibly, \code{TRUE} if the annotation was loaded successfully; an error message if the objects in the
        given file do not encode an annotation.
}
\description{
Loads a previously saved custom region annotation from a binary (RData) file.
}
\details{
If the region annotation cannot be loaded from the specified location, this function exits with an error message in
the form \code{"unable to load object from ..."}. This could happen, for example, when \code{fname} does not refer to
a valid RData file, or the file cannot be accessed due to security restrictions.

If the file is loaded in the current session, but no annotation was added, the function returns invisibly one of the
following short failure messages:
\describe{
  \item{\code{"invalid format"}}{The RData file does not store exactly the following three objects - \code{assembly},
       \code{regions}, and \code{mapping}, or they are not of the expected type.}
  \item{\code{"unsupported assembly"}}{The specified assembly is unknown.}
  \item{\code{"invalid format of regions"}}{The specified region annotation table is invalid.}
  \item{\code{"invalid format of mappings"}}{The specified region mapping tables are invalid.}
}
}
\seealso{
\code{\link{rnb.save.annotation}} for saving annotation to a binary file; \code{\link{rnb.set.annotation}}
         for loading an annotation from a BED file.
}
\author{
Yassen Assenov
}
