% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize.R
\name{sample_size_distribution}
\alias{sample_size_distribution}
\title{sample_size_distribution}
\usage{
sample_size_distribution(
  power = 0.8,
  m = 10000,
  m1 = 100,
  f = 0.1,
  k = 1,
  w = 1,
  rho = 2,
  showMessage = FALSE,
  storeProcess = FALSE,
  distributionObject,
  libSize,
  minAveCount = 5,
  maxAveCount = 2000,
  repNumber = 100,
  dispersionDigits = 1,
  selectedGenes,
  pathway,
  species = "hsa",
  countFilterInRawDistribution = TRUE,
  selectedGeneFilterByCount = FALSE
)
}
\arguments{
\item{power}{Power to detect prognostic genes.}

\item{m}{Total number of genes for testing.}

\item{m1}{Expected number of prognostic genes.}

\item{f}{FDR level}

\item{k}{Ratio of sample size between two groups (Treatment/Control).}

\item{w}{Ratio of normalization factors between two groups.}

\item{rho}{minimum fold changes for prognostic genes between two groups (Treatment/Control).}

\item{showMessage}{Logical. Display the message in the estimation process.}

\item{storeProcess}{Logical. Store the power and n in sample size or power estimation process.}

\item{distributionObject}{A DGEList object generated by est_count_dispersion function. RnaSeqSampleSizeData package contains 13 datasets from TCGA, you can set distributionObject as any one of "TCGA_BLCA","TCGA_BRCA","TCGA_CESC","TCGA_COAD","TCGA_HNSC","TCGA_KIRC","TCGA_LGG","TCGA_LUAD","TCGA_LUSC","TCGA_PRAD","TCGA_READ","TCGA_THCA","TCGA_UCEC" to use them.}

\item{libSize}{numeric vector giving the total count for each sample. If not specified, the libsize in distributionObject will be used.}

\item{minAveCount}{Minimal average read count for each gene. Genes with smaller read counts will not be used.}

\item{maxAveCount}{Maximal average read count for each gene. Genes with larger read counts will be taken as maxAveCount.}

\item{repNumber}{Number of genes used in estimation of read counts and dispersion distribution.}

\item{dispersionDigits}{Digits of dispersion.}

\item{selectedGenes}{Optianal. Name of interesed genes. Only the read counts and dispersion distribution for these genes will be used in power estimation.}

\item{pathway}{Optianal. ID of interested KEGG pathway. Only the read counts and dispersion distribution for genes in this pathway will be used in power estimation.}

\item{species}{Optianal. Species of interested KEGG pathway.}

\item{countFilterInRawDistribution}{Logical. If the count filter will be applied on raw count distribution. If not, count filter will be applied on libSize scaled count distribution.}

\item{selectedGeneFilterByCount}{Logical. If the count filter will be applied to selected genes when selectedGenes parameter was used.}
}
\value{
Estimate sample size or a list including parameters and sample size in the process.
}
\description{
A function to estitamete the sample size based on read counts and dispersion distribution in real data.
}
\details{
A function to estitamete the sample size based on read counts and dispersion distribution in real data.
}
\examples{
#Please note here the parameter repNumber was very small (5) to make the example code faster.
#We suggest repNumber should be at least set as 100 in real analysis.
sample_size_distribution(power=0.8,f=0.01,distributionObject="TCGA_READ",repNumber=5,
showMessage=TRUE)
}
