% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{getFitModel}
\alias{getFitModel}
\alias{getFitModel,Rnits-method}
\alias{getFitModel,character,ANY-method}
\title{Extract fit data from \code{\linkS4class{Rnits}} object}
\usage{
getFitModel(object)

\S4method{getFitModel}{Rnits}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}}}
}
\value{
A data frame containing the model fit results for all genes
}
\description{
Retrieve model fit data from \code{\linkS4class{Rnits}} object after \code{fit} has been run.
}
\details{
Contains Ratio statistic, p-value and cluster ID data
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# P-values, ratio statistics and cluster ID's can be retrieved for all genes together
fitdata <- getFitModel(rnitsobj)
}
}

