% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{plotResults}
\alias{plotResults}
\alias{plotResults,Rnits-method}
\alias{plotResults,character,ANY-method}
\title{Plot profiles of top genes/probes}
\usage{
plotResults(object, id = NULL, fdr = NULL, top = 48, pdf = FALSE,
  sort.by = "p-value", filename = "TopPlots.pdf", scale_y = NULL)

\S4method{plotResults}{Rnits}(object, id = NULL, fdr = NULL, top = 48,
  pdf = FALSE, sort.by = "p-value", filename = "TopPlots.pdf",
  scale_y = NULL)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object.}

\item{id}{Names of specific genes or probes to be plotted. Overrides \code{fdr} and \code{top} argument.}

\item{fdr}{FDR cut-off plotting top probes or genes. Overrides \code{top} argument.}

\item{top}{Number of top genes or probes whose profile is to be plotted. Default \code{48}.}

\item{pdf}{Save plot as pdf? Default \code{FALSE}.}

\item{sort.by}{Criteria for sorting top genes or probes. Default \code{'p-value'}.}

\item{filename}{Name of pdf file. Default \code{topplots.pdf}.}

\item{scale_y}{If 'free', use free scales for plots. Default NULL.}

\item{\dots}{Optional arguments to plot}
}
\description{
After \code{fit} has been applied on \code{\linkS4class{Rnits}} object, plot the profiles
of N top ranking genes/probes.
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# Plot top results
plotResults(rnitsobj, top = 16)

}
}

