# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Title: Convert DNA sequences to Reduced Representation format
#' 
#' @description This function receives a vector of strings (character vector) 
#' containing DNA sequences and returns a vector of strings containing 
#' codified DNA.
#' @param dnas Vector of DNA sequences (character vector).
#' @return Vector of DNA converted to reduced representation format 
#' (character vector).
#' @note This function is used internally to compute top over-represented 
#' reads and to store in RqcResultSet objects (per file top reads).
#' @seealso \code{\link{perFileTopReads}}
#' @author Welliton Souza
#' @examples
#' dna <- "ATCGNATCGTA"
#' dna.converted <- toRRDNA(dna)
#' nchar(dna)
#' nchar(dna.converted)
#' @export
toRRDNA <- function(dnas) {
    .Call('_Rqc_toRRDNA', PACKAGE = 'Rqc', dnas)
}

#' Revert codified DNA sequences to original DNA sequences.
#' 
#' @description This function receives a vector of strings containing codified DNA and 
#' returns a vector of string containing original DNA sequences.
#' @note This function is used internally to restore original DNA sequences 
#' stored in RqcResultSet objects (per file top reads).
#' @param rrdnas Vector of codified DNA (character vector).
#' @return Vector of original DNA sequences (character vector).
#' @seealso \code{\link{perFileTopReads}}
#' @author Welliton Souza
#' @examples
#' dna <- "ATCG"
#' dna.converted <- toRRDNA(dna)
#' dna.reverted <- fromRRDNA(dna.converted)
#' all.equal(dna, dna.reverted)
#' @export
fromRRDNA <- function(rrdnas) {
    .Call('_Rqc_fromRRDNA', PACKAGE = 'Rqc', rrdnas)
}

#' Distance matrix of the similarity between the DNA sequences.
#' 
#' @description This function receives a vector of strings representing codified DNA 
#' sequences and returns a integer matrix representing the similarities 
#' between all sequences from input vectors.
#' @note This function is used internally to compute data for rqcFileHeatmap 
#' function.
#' @param rrdnas Vector of codified DNA sequences (character vector).
#' @return Matrix \eqn{n x n}, where \eqn{n} is the length of the largest 
#' original DNA sequence. 
#' @seealso \code{\link{rqcFileHeatmap}}
#' @author Welliton Souza
#' @examples
#' dna1 <- toRRDNA("atcgn")
#' dna2 <- toRRDNA("atcga")
#' matdist(c(dna1, dna2))
#' @export
matdist <- function(rrdnas) {
    .Call('_Rqc_matdist', PACKAGE = 'Rqc', rrdnas)
}

