% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCBNM.R
\name{SCBN}
\alias{SCBN}
\title{Compute the normalization factor to identify difference expression
(DE) of genes between different species}
\usage{
SCBN(orth_gene, hkind, a=0.05)
}
\arguments{
\item{orth_gene}{Matrix or data.frame containing read counts and gene length
for each orthologous gene between different species. The first and third
column containing gene length, the second and the fourth column containing
read counts.}

\item{hkind}{A vector shows conserved genes position in orthologous genes.}

\item{a}{P-value cutoff in iteration process to find the optimal
normalization factor.}
}
\value{
list(.) A list of computed normalization factors, "median_val"
represents foctors computed by median methods, "scbn_val" represents factors
computed by SCBN methods.
}
\description{
To normalize read counts and identify difference expression(DE)
of orthologous genes between different species.
}
\examples{
data(sim_data)
SCBN(orth_gene=sim_data, hkind=1:1000, a=0.05)
}
