\name{sim.plot.pvals.on.region}

\alias{sim.plot.pvals.on.region}

\title{P-value histograms and P-values along the genome per region}

\description{
	Generates two plots of the P-values for an analyzed region. The first plot contains the   
  	distribution of the raw P-values and ranked plots of the raw and adjusted P-values. 
  	The second plot contains the P-values along the genome of analyzed input regions.
}
\usage{
sim.plot.pvals.on.region(input.regions = c("all chrs"),
						 significance = 0.2,	 
                         adjust.method = "BY",  
                         method = c("full", "smooth", "window", "overlap"),  
                         run.name = "analysis_results", ...)
}

\arguments{
	\item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}.
  	      See \code{\link{integrated.analysis}} for more information.}  
  	      
	\item{significance}{The threshold for selecting significant P-values.}
	
	\item{adjust.method}{Method used to adjust the P-values for multiple testing. see \link[stats:p.adjust]{p.adjust}
         Default is \dQuote{BY} recommended when copy number is used as dependent data. 
         See \link{SIM} for more information about adjusting P-values.}
         
	\item{method}{this must be the either full, window, overlap or smooth but the data should generated by the 
         same method in \code{integrated.analysis}.}
           
	\item{run.name}{This must be the same a given to \code{integrated.analysis}}
	
	\item{...}{Arguments to be passed to \code{pdf}.}
}
\details{
	This function returns a pdf containing the P-value plots. The second plot contains the multiple testing corrected P-values 
plotted along the chromosome (arm). 
On the x-axis, the start positions of the dependent features are displayed. On the y-axis, the P-value levels are displayed. 
Two dotted lines indicate P-value levels 0.2 and 0.1. In general, 
P-values below 0.2 are said to be \dQuote{significant}.
}

\value{
	No values are returned. The results are stored in a subdirectory of \code{run.name} as pdf.
}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes  \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{sim.plot.pvals.on.genome}
}

\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
#plot the p-values along the regions
sim.plot.pvals.on.region(input.regions="8q",			
		                 adjust.method="BY", 
						 method="full", 
						 run.name="chr8q")
}
\keyword{hplot}

