% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hart.R
\name{Hart}
\alias{Hart}
\title{Hart}
\usage{
Hart(datInput)
}
\arguments{
\item{datInput}{A dataframe with column names: idRun, idPrey. 
Each row represent one unique protein captured in one pull-down experiment.}
}
\value{
A dataframe consists of pairwise combindation of preys identified in 
the input with Hart scores indicating interacting probabilities computed from 
negative log transformed Hypergeometric test P-values.
}
\description{
Hart
Scoring algorithm based on a hypergeometric distribution error model (Hart et al.,2007).
}
\examples{
data(TestDatInput)
datScore <- Hart(TestDatInput)
head(datScore)
}
\references{
Hart, G. Traver, Insuk Lee, and Edward M. Marcotte. 
'A high-accuracy consensus map of yeast protein complexes reveals modular 
nature of gene essentiality.' BMC bioinformatics 8.1 (2007): 236.
\url{https://doi.org/10.1186/1471-2105-8-236}
}
\author{
Qingzhou Zhang, \email{zqzneptune@hotmail.com}
}
