% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCategoryElements.R
\name{getCategoryElements}
\alias{getCategoryElements}
\title{Get all elements of a given category}
\usage{
getCategoryElements(category, verbose = FALSE, includeTemplates = FALSE,
  limit, baseURL, format, query, continue)
}
\arguments{
\item{category}{The category to be used. Just one at a time.}

\item{verbose}{If TRUE some messages are provided.}

\item{includeTemplates}{If TRUE page templates are kept in the output.}

\item{limit}{The maximum number of items to be queried at a time.}

\item{baseURL}{SNPedia boots URL.}

\item{format}{Downloading format. Currently just JSON is available.}

\item{query}{The query to be iterated.}

\item{continue}{To be used in multi-page queries.}
}
\value{
A character vector containing the names of the pages under
the required category.
}
\description{
A function to get all page names of SNPedia tagged under the indicated
category.
}
\details{
A list of all available categories may be found at:

\url{http://www.snpedia.com/index.php/Special:Categories}

Most used categories are:
\itemize{
\item Is_a_medical_condition
\item Is_a_medical_condition
\item Is_a_medicine
\item Is_a_topic
\item Is_a_snp
\item In_dbSNP
\item Is_a_genotype
}

Some template pages are included in their corresponding category.
By default those will be removed.
Set includeTemplates to TRUE is you want to keep them.

Parameters other than category and verbose are not intended for
standard users.
}
\examples{
res <- getCategoryElements(category = "Is_a_medical_condition")
head(res)

\dontrun{
res <- getCategoryElements(category = "Is_a_snp")
}

}
\seealso{
getPages, extractTags
}
