% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\docType{methods}
\name{counts,SNPhood-method}
\alias{counts}
\alias{counts,SNPhood-method}
\title{Extract count data from a \code{\link{SNPhood}} object.}
\usage{
\S4method{counts}{SNPhood}(object, type = "binned", readGroup = NULL,
  dataset = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{SNPhood}}

\item{type}{Character(1). Default "binned". Either "binned" or "unbinned" to extract counts after or before binning the SNP regions, respectively.}

\item{readGroup}{Character(1). Default NULL. Read group that should be plotted, specified by its name as obtained by the function \code{annotationReadGroups}). If only one read group is defined in the object, this may also be NULL for user conveniance.}

\item{dataset}{Numeric(1) or Character(1). Single dataset that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or its annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}).}

\item{...}{not used}
}
\value{
A named nested list with the requested count data, organized after read group and dataset.
}
\description{
\code{counts} extracts count data from a \code{\link{SNPhood}} object. The full count data or only a subset can be extracted 
by settings the parameters \code{type}, \code{readGroup} and \code{dataset} accordingly. Either the count data
for the unbinned or binned SNP regions can be extracted.
}
\examples{
data(SNPhood.o, package="SNPhood")
str(counts(SNPhood.o))
str(counts(SNPhood.o, readGroup = "paternal", dataset = 1))
str(counts(SNPhood.o, readGroup = c("maternal", "paternal"), dataset = 1))
}
\seealso{
\code{\link{SNPhood}}, \code{\link{enrichment}}
}

