% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{eventPlot}
\alias{eventPlot}
\title{eventPlot}
\usage{
eventPlot(
  transcripts,
  roi_plot = NULL,
  bams = c(),
  names = c(),
  annoLabel = c("Gene A"),
  rspan = 1000,
  pfam_dom = NULL,
  showAll = TRUE
)
}
\arguments{
\item{transcripts}{GRanges object}

\item{roi_plot}{GRanges object region to plot}

\item{bams}{character vector of bam file locations}

\item{names}{character vector of name labels}

\item{annoLabel}{character. annotation label}

\item{rspan}{integer or NULL. number of basepairs to span from roi.
if NULL, will consider whole gene of roi}

\item{pfam_dom}{optional GRanges object of PFAM domains from UCSC Tables.}

\item{showAll}{logical. TRUE = display splice junctions of entire view or
FALSE = just roi.}
}
\value{
a Gviz plot of genomic region
}
\description{
eventPlot
}
\examples{
# define BAM files
data_path<-system.file("extdata",package="SPLINTER")
mt<-paste(data_path,"/mt_chr14.bam",sep="")
wt<-paste(data_path,"/wt_chr14.bam",sep="")

# plot results
eventPlot(transcripts=valid_tx,roi_plot=roi,bams=c(wt,mt),
 names=c('wt','mt'),rspan=1000)
}
\author{
Diana Low
}
