% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_caClass.R
\name{getLoadings}
\alias{getLoadings}
\alias{getLoadings,caClass-method}
\title{Retrieve component analysis loadings}
\usage{
getLoadings(x, part=NULL, block=NULL)
}
\arguments{
\item{x}{\code{\link{caClass-class}} object.}

\item{part}{Character indicating whether "common" or "distinctive" loadings should be displayed}

\item{block}{Character indicating the block of data for which the loadings will be given. It can be specified by the position of the block ("1" or "2") or the name assigned in the \code{\link{caClass-class}} object. If it is NULL both blocks are displayed.}
}
\value{
A list containing the requested information.
}
\description{
Generic function to retrieve loadings (common and distinctive) found by \code{\link{omicsCompAnalysis}} on a \code{\link{caClass-class}} object.
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA, pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA, pDataDescr=c("classname"))
# Omics components analysis
res <- omicsCompAnalysis(Input=list(B1, B2), Names=c("expr", "mirna"),
                         method="DISCOSCA", Rcommon=2, Rspecific=c(2, 2),
                         center=TRUE, scale=TRUE, weight=TRUE)
getLoadings(res)
getLoadings(res, part="common", block="expr")
getLoadings(res, part="distinctive", block="expr")
}
\seealso{
\code{\link{omicsCompAnalysis}}, \code{\link{caClass-class}}
}
\author{
Patricia Sebastian-Leon
}
