% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{CollapseStrands}
\alias{CollapseStrands}
\title{Collapse strands}
\usage{
CollapseStrands(MethGR, context)
}
\arguments{
\item{MethGR}{Granges obj of average methylation}

\item{context}{"GC" or "HCG". Broad because indicates just the directionality of collapse.}
}
\value{
MethGR with collapsed strands (everything turned to - strand)
}
\description{
Collapse strands
}
\examples{

Methylation = qs::qread(system.file(
    "extdata", "Methylation_3.qs", package="SingleMoleculeFootprinting"
    ))
MethGR = plyranges::filter(Methylation[[1]], GenomicContext == "GCH")
CollapseStrands(MethGR = MethGR, context = "GC")

}
