% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_proteome_phospho.R
\name{preprocessPhos}
\alias{preprocessPhos}
\title{Preprocess Phosphoproteome Data}
\usage{
preprocessPhos(
  seData,
  filterList = NULL,
  missCut = 50,
  transform = c("log2", "vst", "none"),
  normalize = FALSE,
  getFP = FALSE,
  removeOutlier = NULL,
  assayName = NULL,
  batch = NULL,
  scaleFactorTab = NULL,
  impute = c("none", "QRILC", "MLE", "bpca", "missForest", "MinDet"),
  verbose = FALSE
)
}
\arguments{
\item{seData}{A \code{SummarizedExperiment} object containing phosphoproteome
data.}

\item{filterList}{A \code{list} of filters to apply on the samples. Default
is \code{NULL}.}

\item{missCut}{\code{Numeric} value specifying the missing value cutoff
percentage for filtering features. Default is 50.}

\item{transform}{\code{Character} string specifying the transformation
method ("log2", "vst", "none"). Default is "log2".}

\item{normalize}{\code{Logical} value indicating whether to normalize the
data. Default is \code{FALSE}.}

\item{getFP}{\code{Logical} value indicating whether to retrieve FP samples.
Default is \code{FALSE}.}

\item{removeOutlier}{\code{Character} vector of samples to be removed as
outliers. Default is \code{NULL}.}

\item{assayName}{\code{Character} string specifying the assay name in the
SummarizedExperiment object. Default is \code{NULL}.}

\item{batch}{\code{Character} vector specifying batch effects to remove.
Default is \code{NULL}.}

\item{scaleFactorTab}{\code{Data frame} containing scale factors for
normalization. Default is \code{NULL}.}

\item{impute}{\code{Character} string specifying the imputation method
("QRILC", "MLE", "bpca", "missForest", "MinDet", "none"). Default is "none".}

\item{verbose}{\code{Logical} value indicating whether to print detailed
information. Default is \code{FALSE}.}
}
\value{
A \code{SummarizedExperiment} object with preprocessed
phosphoproteome data.
}
\description{
\code{preprocessPhos} preprocesses phosphoproteome data stored in a
\code{SummarizedExperiment} object by performing filtering, transformation,
normalization, imputation, and batch effect removal.
}
\examples{
library(SummarizedExperiment)
# Load multiAssayExperiment object
data("dia_example")
# Get SummarizedExperiment object
se <- dia_example[["Phosphoproteome"]]
colData(se) <- colData(dia_example)
# Call the function
preprocessPhos(seData = se, normalize = TRUE, impute = "QRILC")

}
