% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSpots.R
\name{removeSpots}
\alias{removeSpots}
\title{removeSpots}
\usage{
removeSpots(sObj, pointsToRemove = "points_to_remove.txt")
}
\arguments{
\item{sObj}{Either a Seurat object (version 3) or a SingleCellExperiment 
object containing barcode coordinates in the metadata (Seurat) or
colData (SingleCellExperiment).}

\item{pointsToRemove}{path to points to remove file. Default is 
"points_to_remove.txt"}
}
\value{
A filtered Seurat or SingleCellExperiment Object
}
\description{
A function to filter spots from analysis. It requires selectSpots to be 
run first.
}
\examples{
sceObj <- readRDS(file.path(system.file(package = "Spaniel"),
                        "extdata/sceData.rds"))
toRemove <- file.path(system.file(package = "Spaniel"),
                        "points_to_remove.txt")
sceObj_filtered <- removeSpots(sObj = sceObj, pointsToRemove = toRemove)
}
