% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialCPie.R
\name{.preprocessData}
\alias{.preprocessData}
\title{Preprocess data}
\usage{
.preprocessData(counts, margin, resolutions, assignmentFunction,
  coordinates = NULL)
}
\arguments{
\item{counts}{count matrix. \code{rownames} should correspond to genes and
\code{colnames} should correspond to spot coordinates.}

\item{margin}{which margin of the count matrix to cluster. Valid values are
\code{c("spot", "sample", "gene", "feature")}.}

\item{resolutions}{vector of resolutions to cluster.}

\item{assignmentFunction}{function to compute cluster assignments. The
function should have the following signature: integer (number of clusters) ->
(m, n) feature matrix -> m-length vector (cluster assignment of each data
point).}

\item{coordinates}{optional \code{\link[base]{data.frame}} with pixel
coordinates for each spot. \code{rownames} should correspond to the \code{colnames} of
\code{counts} and the columns \code{x} and \code{y} should specify the pixel coordinates of
the spots.}
}
\value{
list with the following elements:
\itemize{
\item \code{$assignments}: tidy assignments
\item \code{$means}: cluster means
\item \code{$scores}: cluster scores for each spot in each resolution
\item \code{$colors}: cluster colors
\item \code{$coordinates}: spot coordinates, either from \code{coordinates} or parsed from
\code{assignments}
\item \code{$featureName}: name of the clustered feature (the "opposite" of \code{margin})
}
}
\description{
Preprocesses input data for \code{\link{.makeServer}}.
}
\keyword{internal}
