% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/florets.R
\name{florets}
\alias{florets}
\title{Draw coxcomb plots as points in a graphics window}
\usage{
florets(
  x,
  y,
  b,
  col = NULL,
  legendwindow = FALSE,
  rescale.by.sqrt = TRUE,
  border = NA,
  add = FALSE,
  cex = 1,
  bty = "n",
  xaxt = "n",
  yaxt = "n",
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{x}{Vector of x coordinates}

\item{y}{Vector of y coordinates}

\item{b}{matrix or cell abundances, with columns aligned with the elements
of x and y}

\item{col}{vector of colors, aligned to the rows of b.}

\item{legendwindow}{Logical. If TRUE, the function draws a color legend in a
new window}

\item{rescale.by.sqrt}{Logical, for whether to rescale b by its square root
to make value proportional to
 shape area, not shape length.}

\item{border}{Color of pie segment border, defauls to NA/none}

\item{add}{Logical. If TRUE, the function draws florets atop an existing
graphics device (TRUE) or call a new device (FALSE).}

\item{cex}{Floret size. Florets are scaled relative to the range of x and y;
this further scales up or down.}

\item{bty}{bty argument passed to plot()}

\item{xaxt}{xaxt argument passed to plot()}

\item{yaxt}{yaxt argument passed to plot()}

\item{xlab}{xlab, defaults to ""}

\item{ylab}{ylab, defaults to ""}

\item{...}{additional arguments passed to plot()}
}
\value{
Draws a coxcomb plot, returns no data.
}
\description{
Draws a scatterplot where each point is a circular barplot, intended to show
decon results
}
\examples{
data(mini_geomx_dataset)
data(safeTME)
# estimate background:
mini_geomx_dataset$bg <- derive_GeoMx_background(
  norm = mini_geomx_dataset$normalized,
  probepool = rep(1, nrow(mini_geomx_dataset$normalized)),
  negnames = "NegProbe"
)
# run basic decon:
res0 <- spatialdecon(
  norm = mini_geomx_dataset$normalized,
  bg = mini_geomx_dataset$bg,
  X = safeTME
)
# draw florets:
florets(
  x = mini_geomx_dataset$annot$x,
  y = mini_geomx_dataset$annot$y,
  b = res0$beta, cex = 2
)
}
